'use strict';
var themeRoot = '.';
var gulp = require('gulp');
var sass = require('gulp-sass');
var autoprefixer = require('gulp-autoprefixer');
var debug = require('gulp-debug');

sass.compiler = require('node-sass');

gulp.task('sass', function () {
  return gulp.src(themeRoot+'/css/scss/style.scss')
    .pipe(sass.sync().on('error', sass.logError))
    .pipe(autoprefixer())
    .pipe(gulp.dest(themeRoot+'/css/build'))
    .pipe(debug());
});

gulp.task('watch:sass', function () {
  gulp.watch(themeRoot+'/css/scss/**/*.scss', gulp.series('sass'));
});

gulp.task('watch', gulp.series('watch:sass'));
gulp.task('default', gulp.series([
  'sass',
]));