<?php
/**
 * Project Block Link Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$class_name = 'project-block-link';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}

$url = get_field('url') ?: '#';
$title = get_field('title') ?: '';
$headline = get_field('headline') ?: '';
$image = get_field('image');

?>

<a class="<?= esc_attr( $class_name ) ?>" href="<?= $url ?>">
    <?php
    if (is_array($image) && array_key_exists('url', $image)) { 
    ?>
    <div class="background-image" style="background-image: url(<?= $image['url'] ?>);"></div>
    <?php 
    } 
    ?>
    <div class="gradient-overlay"></div>
    <div class="text-content">
        <h5><?= $title ?></h5>
        <h4><?= $headline ?></h4>
    </div>
</a>
