// Brand Center theme scripts
theme = {
    path : '/wp-content/themes/adw-theme/',
}

// console.log('Brand Center init');
jQuery(document).ready(function($) {
    /*
    * Mobile Menu
    */
    if ($('#mobile-nav').length) {
        $('#mobile-nav').slicknav({
            appendTo : 'header',
        });
    }

    /*
    * Carousels
    */
    //if ($('.carousel-block').length) {
    //    $('.carousel-block').each(function(){
    //        var autoplay = $(this).attr('data-autoplay') ? true : false;
    //        var autoplayspeed = $(this).attr('data-autoplayspeed');
    //        if(autoplayspeed < 2000) {
    //            autoplayspeed = 2000;
    //        }
    //        $(this).children('.acf-innerblocks-container').slick({
    //            arrows: true,
    //            dots: true,
    //            slidesToShow: 1,
    //            autoplay: autoplay,
    //            autoplaySpeed: autoplayspeed,
    //        });
    //    });
    //}

    const navbar = document.querySelector("header");
    const navbarOffset = navbar.offsetTop;
    const navbarHeight = navbar.offsetHeight;

    function stickyNav() {
      if (window.pageYOffset >= navbarOffset) {
        navbar.classList.add("sticky");
        document.querySelector('main').style.paddingTop = `${navbarHeight}px`;
      } else {
        navbar.classList.remove("sticky");
      }
    }

    // Fade-in content on sroll
    function isScrolledIntoView(elem) {
        const docViewTop = $(window).scrollTop();
        const docViewBottom = docViewTop + $(window).height();
        const elemTop = $(elem).offset().top;
        return ((elemTop <= docViewBottom));
    }

    $('.fade-in-on-scroll').each(function(){
      if(isScrolledIntoView(this)){
        fadeIn(this);
      }
    });

    window.onscroll = function(){
      stickyNav()

      $('.fade-in-on-scroll').each(function(){
        if(isScrolledIntoView(this)){
          fadeIn(this);
        }
      });
    }

    function fadeIn(el) {
      setTimeout(function(){
        $(el).addClass('fade-in');
        $(el).removeClass('fade-in-on-scroll');
      }, 500);
    }

    $("a").on('click', function(event) {
        if (this.hash !== "") {
          event.preventDefault();
          const hash = this.hash;

          $('html, body').animate({
            scrollTop: $(hash).offset().top - navbarHeight,
            easing: 'easein',
          }, 600, function(){
            window.location.hash = hash;
          });
        }
    });

    $('.slicknav_nav').addClass('slicknav_hidden').hide();
    $('.slicknav_open').addClass('slicknav_collapsed').removeClass('slicknav_open');

    $('.slicknav_nav').on('click', 'a', function(e){
      $('.slicknav_nav').addClass('slicknav_hidden');
      $('.slicknav_open').addClass('slicknav_collapsed').removeClass('slicknav_open');
    })

    $('.slide-in-out-toggle').removeClass('active');
    $('.slide-in-out-container').removeClass('slide-in');

    $('.slide-in-out-toggle').on('click', function(e){
      e.preventDefault();
      const $target = $(this).attr('data-target') ? $($(this).attr('data-target')) : $(this).closest('div').find('.slide-in-out-container');

      if (window.innerWidth > 768 && $(this).hasClass('team-member-toggle') ){
        window.scrollTo({
          top: $(this).closest('.wp-block-columns').offset().top - navbarHeight ,
          behavior: "smooth",
        });
      }

      $(this).toggleClass('active');

      if($target.hasClass('slide-in')) {
        $target.removeClass('slide-in');
        $target.addClass('slide-out');
      } else {
        $('.slide-in-out-container.slide-in').removeClass('slide-in').addClass('slide-out');
        $target.addClass('slide-in');
        $target.removeClass('slide-out');
      }
    });

    $('.slide-in-out-container').on('click', 'a', function(e){
      $('.slide-in-out-toggle').removeClass('active');
      $('.slide-in-out-container').addClass('slide-out');
      $('.slide-in-out-container').removeClass('slide-in');
    });

    $('.close-container').on('click', function(e){
      e.preventDefault();
      $container = $(this).closest('.slide-in-out-container');
      $container.removeClass('slide-in');
      $container.addClass('slide-out');
      $('.slide-in-out-toggle').removeClass('active');
    });


    // Menu - fix menu item opacity if no current page
    if ( !$('[aria-current="page"').length ) {
      $('header .wp-block-navigation a').css('opacity', '1');
    }

    // Disable tag button click
    $('.wp-block-post-terms').on('click', function(e){
      e.preventDefault();
    })
});
