<?php
/**
 * Background Container Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$class_name = 'background-container alignfull';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}
$background = get_field('background') ?: '';

?>

<div class="<?= esc_attr( $class_name ) ?>" style="<?php if( $background['color'] ) { echo('background-color:' . $background['color'] . ';'); } if( $background['image'] ) { echo('background-image: url(' . $background['image']['url'] . ');'); } ?>">
    <div class="wp-block-group__inner-container">
        <InnerBlocks />
    </div>
</div>