<?php
/**
 * Project Info Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$class_name = 'project-info';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}

?>

<div class="project-info--toggle">+ Project Information</div>

<div class="<?= esc_attr( $class_name ) ?>">
    <!-- FIXME add tags -->

    <!-- wp:post-title /-->

    <div class="wp-block-group__inner-container">
        <InnerBlocks />
    </div>
</div>