<?php
/**
 * Project Info Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$class_name = 'project-list';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}

$title = get_field('title') ?: 'All Projects';
$items = get_field('project_items');

?>

<div class="sticky-banner-button slide-in-out-toggle" data-target=".project-list">
    <span class="toggle-text"><span class="toggle-plus">&plus;</span> Project List</span>
</div>

<div class="<?= esc_attr( $class_name ) ?> slide-in-out-container">
    <a href="#" class="close-container">
        <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M48 1.39L46.61 0L24 22.61L1.39 0L0 1.39L22.61 24L0 46.61L1.39 48L24 25.39L46.61 48L48 46.61L25.39 24L48 1.39Z" fill="black"/>
        </svg>
    </a>
    <h4><?= $title ?></h4>
    <table>
        <thead>
            <tr>
                <th><h5>Project Name</h5></th>
                <th><h5>Client</h5></th>
            </tr>
        </thead>
        <tbody>
        <?php
            if( $items ) {
                foreach( $items as $row ) {
                    echo '<tr>';
                        echo '<td class="name">';
                            echo '<a href="' . $row['url'] . '">';
                                echo '<p>' . $row['title'] . '</p>';
                            echo '</a>';
                        echo '</td>';
                        echo '<td class="client">';
                            echo $row['client'];
                        echo '</td>';
                    echo '</tr>';
                }
            }
        ?>
        </tbody>
    </table>
</div>