<?php
/**
 * Carousel Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */

// Create class attribute allowing for custom "className" and "align" values.
$class_name = 'carousel-block';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}
$class_name .= get_field('full_width') ? ' alignfull': '';
$class_name .= get_field('show_caption') ? ' show-caption': '';
$class_name .= get_field('show_navigation_arrows') ? ' show-arrows': '';
$show_caption = get_field('show_caption');

$atts = array();
$atts['data-autoplay'] = get_field('auto_play') ?: false;
$atts['data-autoplayspeed'] = get_field('auto_play_speed') ?: 5000;

$attributes = '';
foreach ( $atts as $attr => $value ) {
    if ( ! empty( $value ) ) {
        $attributes .= ' ' . $attr . '="' . $value . '"';
    }
}

$carousel_overlay = get_field('carousel_overlay');
if ($carousel_overlay) {
    $overlay_content = get_field('overlay_content');
}

$allowed_blocks = [
    [ 'acf/carousel-slide' ]
]
?>
<div <?= $anchor ?>class="<?= esc_attr( $class_name ) ?>" style="<?= esc_attr( $style ) ?>"<?= $attributes ?>>
    <?php
        if ($overlay_content) {
            ?>
                <div class="carousel-overlay">
                    <ul class="carousel-overlay__list">
                        <?php foreach ( $overlay_content as $item ) { ?>
                            <li<?php if ( $item['underline_color'] ) { echo (' style="border-color:' . $item['underline_color'] . ';"'); } ?>>
                                <img src="<?= $item['icon']['url'] ?>" alt="<?= $item['icon']['alt'] ?>">
                                <span><?= $item['text'] ?></span>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
            <?php
        }
    ?>
    <?php
        echo '<InnerBlocks allowedBlocks="' . esc_attr( wp_json_encode( $allowed_blocks ) ) . '" />';
    ?> 
    <?php 
        if ($show_caption) {
            ?>
            <p class="carousel-caption"></p>
            <?php
        }
    ?>
</div>