<?php
/**
 * Carousel Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$class_name = 'slide';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}
$background = get_field('background') ?: '';
$title = get_field('slide_title') ?: '';

?>

<div class="<?= esc_attr( $class_name ) ?>" style="<?php if( $background['color'] ) { echo('background-color:' . $background['color'] . ';'); } if( $background['image'] ) { echo('background-image: url(' . $background['image']['url'] . ');'); } ?>"<?php if( $title ) { echo(' data-slide-title="' . $title . '"'); } ?>>
    <div class="slide__content-container">
        <InnerBlocks />
    </div>
</div>