<?php
/**
 * Site Logo Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$color = get_field( 'color' ) ?: '#000000';

?>
<a class="site-logo" <?php if(!is_admin()){ ?>href="/"<?php } ?>>
  <?php if(!is_admin()){ ?>
    <span class="visuallyhidden">Applied Design</span>
  <?php } ?>
  <svg xmlns="http://www.w3.org/2000/svg" width="170" height="25" viewBox="0 0 170 25" fill="<?= $color ?>">
    <path d="M107.103 13.9978C106.378 14.8618 105.256 15.2939 103.729 15.2939H102.484V5.14557H104.071C105.43 5.14557 106.455 5.54944 107.148 6.35717C107.841 7.1649 108.188 8.41877 108.188 10.1094C108.188 11.8 107.828 13.129 107.103 13.9931M109.989 3.96684C108.535 2.59088 106.524 1.90525 103.957 1.90525H98.6358V18.553H103.505C105.302 18.553 106.848 18.2337 108.147 17.5997C109.446 16.961 110.44 16.0077 111.133 14.7444C111.826 13.4765 112.173 11.8892 112.173 9.97788C112.173 7.35275 111.443 5.3475 109.989 3.97624M117.439 10.6306C117.512 9.80882 117.745 9.20302 118.128 8.82263C118.511 8.44225 118.999 8.24971 119.587 8.24971C120.298 8.24971 120.822 8.47982 121.174 8.94004C121.52 9.40026 121.702 9.96379 121.716 10.6306H117.439ZM119.523 5.52596C118.315 5.52596 117.261 5.77015 116.363 6.25855C115.465 6.74695 114.767 7.48893 114.27 8.48451C113.773 9.48009 113.523 10.7293 113.523 12.2367C113.523 13.7442 113.796 14.9605 114.348 15.9326C114.9 16.9047 115.661 17.6232 116.632 18.0881C117.603 18.553 118.72 18.7878 119.97 18.7878C120.982 18.7878 121.83 18.7127 122.519 18.5671C123.207 18.4215 123.859 18.182 124.475 17.858V14.9417C123.782 15.2845 123.107 15.5334 122.45 15.6884C121.794 15.8433 121.073 15.9232 120.289 15.9232C119.368 15.9232 118.661 15.6743 118.16 15.1765C117.663 14.6787 117.398 14.0118 117.366 13.1712H125.222V11.3538C125.222 9.44252 124.707 7.99142 123.681 7.00523C122.655 6.01905 121.265 5.52596 119.514 5.52596M72.4141 10.6306C72.4871 9.80882 72.7196 9.20302 73.1026 8.82263C73.4856 8.44225 73.9735 8.24971 74.5616 8.24971C75.2684 8.24971 75.7973 8.47982 76.1483 8.94004C76.4949 9.40026 76.6773 9.96379 76.6909 10.6306H72.4141ZM74.4978 5.52596C73.2895 5.52596 72.2363 5.77015 71.3381 6.25855C70.4398 6.74695 69.7422 7.48893 69.2452 8.48451C68.7483 9.48009 68.4975 10.7293 68.4975 12.2367C68.4975 13.7442 68.7711 14.9605 69.3228 15.9326C69.8745 16.9047 70.6359 17.6232 71.6071 18.0881C72.5783 18.553 73.6953 18.7878 74.9446 18.7878C75.9568 18.7878 76.8049 18.7127 77.4934 18.5671C78.1819 18.4215 78.8339 18.182 79.454 17.858V14.9417C78.7609 15.2845 78.0861 15.5334 77.4296 15.6884C76.773 15.8433 76.0526 15.9232 75.2684 15.9232C74.3473 15.9232 73.6406 15.6743 73.1391 15.1765C72.6421 14.6787 72.3776 14.0118 72.3457 13.1712H80.2017V11.3538C80.2017 9.44252 79.6911 7.99142 78.6606 7.00523C77.6347 6.01905 76.2441 5.52596 74.4932 5.52596M89.7311 12.5701C89.7174 13.6127 89.5396 14.3875 89.1977 14.9041C88.8557 15.416 88.2812 15.6743 87.465 15.6743C86.7994 15.6743 86.275 15.3925 85.892 14.8337C85.509 14.2748 85.313 13.4107 85.313 12.2461C85.313 11.0815 85.4999 10.1798 85.8783 9.5881C86.2568 8.99639 86.7674 8.70053 87.4194 8.70053C88.3086 8.70053 88.915 9.00578 89.2432 9.61158C89.567 10.2174 89.7311 11.0909 89.7311 12.2226V12.5748V12.5701ZM89.4348 4.64308C89.4348 5.15496 89.4621 5.67154 89.5123 6.1928C89.567 6.71407 89.6126 7.11324 89.6582 7.39501H89.567C89.2341 6.86905 88.7964 6.42291 88.2538 6.06601C87.7113 5.7091 87 5.53065 86.1246 5.53065C84.7385 5.53065 83.6123 6.08949 82.7505 7.21186C81.8888 8.32954 81.4602 9.98727 81.4602 12.1804C81.4602 14.3734 81.8842 16.003 82.7277 17.1254C83.5712 18.2431 84.6655 18.8019 86.0106 18.8019C86.886 18.8019 87.5973 18.6187 88.1399 18.2524C88.6824 17.8861 89.111 17.44 89.4302 16.9094H89.5898L90.3603 18.5671H93.2556V0.83453H89.4302V4.63369L89.4348 4.64308ZM137.747 18.5624H141.55V5.75137H137.747V18.553V18.5624ZM151.622 12.6406C151.622 13.7442 151.449 14.5378 151.102 15.0168C150.756 15.5005 150.181 15.74 149.383 15.74C148.658 15.74 148.12 15.4583 147.765 14.89C147.409 14.3218 147.231 13.4389 147.231 12.2414C147.231 9.8323 147.933 8.6254 149.338 8.6254C150.181 8.6254 150.774 8.91186 151.116 9.48948C151.458 10.0671 151.626 10.95 151.626 12.1475V12.6359L151.622 12.6406ZM151.599 7.37153H151.508C151.129 6.7986 150.655 6.34308 150.081 6.01905C149.506 5.69502 148.813 5.53065 147.997 5.53065C146.579 5.53065 145.448 6.10827 144.614 7.25413C143.775 8.40468 143.355 10.0436 143.355 12.1757C143.355 14.3077 143.766 15.9232 144.591 17.0737C145.412 18.2243 146.524 18.7972 147.929 18.7972C148.713 18.7972 149.388 18.6328 149.953 18.3088C150.518 17.9848 150.984 17.5152 151.344 16.9094H151.458C151.426 17.1723 151.403 17.4494 151.38 17.7359C151.357 18.0223 151.348 18.2759 151.348 18.4919V18.7502C151.348 20.3845 150.482 21.1969 148.745 21.1969C147.824 21.1969 146.994 21.1171 146.255 20.9527C145.517 20.7883 144.76 20.5442 143.994 20.2201V23.4135C144.719 23.6952 145.457 23.8878 146.21 23.9958C146.962 24.1038 147.81 24.1602 148.745 24.1602C150.888 24.1602 152.493 23.6859 153.555 22.7372C154.617 21.7886 155.151 20.408 155.151 18.5859V5.75137H151.891L151.595 7.36214L151.599 7.37153ZM168.091 6.63894C167.284 5.90164 166.221 5.53065 164.908 5.53065C164.092 5.53065 163.354 5.69032 162.688 6.00966C162.022 6.32899 161.498 6.7986 161.101 7.41849H160.919L160.399 5.76546H157.499V18.5671H161.325V12.7392C161.325 11.4196 161.489 10.4052 161.822 9.69611C162.154 8.99169 162.779 8.63479 163.7 8.63479C164.32 8.63479 164.772 8.8602 165.059 9.31103C165.346 9.76186 165.487 10.4287 165.487 11.3163V18.5671H169.29V10.2221C169.29 8.57374 168.884 7.38092 168.077 6.64363M141.112 1.04116C140.706 0.792265 140.228 0.670166 139.685 0.670166C139.111 0.670166 138.623 0.792265 138.226 1.04116C137.825 1.29005 137.624 1.77375 137.624 2.48756C137.624 3.20138 137.825 3.66629 138.226 3.91988C138.627 4.17817 139.115 4.30496 139.685 4.30496C140.228 4.30496 140.702 4.17817 141.112 3.91988C141.518 3.6616 141.723 3.18729 141.723 2.48756C141.723 1.78784 141.518 1.29005 141.112 1.04116ZM134.556 11.6168C134.059 11.2834 133.452 10.9688 132.746 10.6729C132.034 10.363 131.496 10.1188 131.127 9.9497C130.758 9.78064 130.507 9.62097 130.379 9.4707C130.251 9.32512 130.188 9.16545 130.188 8.99169C130.188 8.52678 130.625 8.29197 131.501 8.29197C131.97 8.29197 132.495 8.3765 133.074 8.55026C133.653 8.71932 134.255 8.94473 134.875 9.2265L135.96 6.56849C135.203 6.21159 134.474 5.94861 133.762 5.77485C133.051 5.60579 132.299 5.51656 131.496 5.51656C129.987 5.51656 128.774 5.82181 127.862 6.437C126.95 7.05219 126.494 7.96324 126.494 9.17484C126.494 9.88865 126.613 10.4851 126.846 10.9594C127.078 11.4337 127.434 11.8422 127.908 12.1851C128.382 12.5279 128.988 12.8613 129.732 13.19C130.484 13.5141 131.054 13.777 131.441 13.9696C131.829 14.1621 132.084 14.3406 132.212 14.4955C132.34 14.6505 132.404 14.829 132.404 15.0309C132.404 15.3127 132.276 15.5287 132.016 15.6837C131.761 15.8386 131.346 15.9185 130.771 15.9185C130.229 15.9185 129.563 15.8292 128.779 15.6508C127.995 15.4723 127.238 15.2094 126.517 14.8712V18.0411C127.183 18.3229 127.839 18.5154 128.496 18.6234C129.153 18.7314 129.919 18.7878 130.794 18.7878C132.604 18.7878 133.936 18.4168 134.788 17.6795C135.641 16.9422 136.069 15.942 136.069 14.6834C136.069 13.9367 135.942 13.3215 135.686 12.8425C135.431 12.3588 135.053 11.9502 134.556 11.6168ZM66.3363 1.04116C65.9305 0.792265 65.4517 0.670166 64.9092 0.670166C64.3347 0.670166 63.8468 0.792265 63.4501 1.04116C63.0489 1.29005 62.8483 1.77375 62.8483 2.48756C62.8483 3.20138 63.0489 3.66629 63.4501 3.91988C63.8514 4.17817 64.3347 4.30496 64.9092 4.30496C65.4517 4.30496 65.9305 4.17817 66.3363 3.91988C66.7421 3.6616 66.9473 3.18729 66.9473 2.48756C66.9473 1.78784 66.7421 1.29005 66.3363 1.04116ZM6.33316 3.81657H3.4789L3.5017 7.45136L0 7.42788V10.3207L3.5017 10.2972L3.4789 13.9038H6.33316V10.2972L9.81662 10.3207V7.42788L6.33316 7.45136V3.81657ZM18.5754 11.6732L19.5284 8.33893C19.6059 8.07595 19.7016 7.70496 19.8247 7.23065C19.9433 6.75634 20.071 6.26794 20.1986 5.76076C20.3263 5.25358 20.422 4.83093 20.4813 4.48811C20.5588 4.83093 20.6591 5.24888 20.7868 5.74667C20.9145 6.24446 21.0421 6.72816 21.1698 7.20247C21.2975 7.67678 21.3978 8.05247 21.4753 8.33424L22.4237 11.6685H18.5754V11.6732ZM17.9873 1.8348L12.4839 18.553H16.6969L17.6955 14.9839H23.2854L24.2794 18.553H28.4924L22.9252 1.8348H17.9918H17.9873ZM62.9805 18.553H66.7831V5.75137H62.9805V18.553ZM49.1105 15.6132C48.2943 15.6132 47.738 15.308 47.4371 14.7022C47.1362 14.0964 46.9857 13.2229 46.9857 12.0911V11.7436C46.9994 10.7011 47.159 9.92152 47.4599 9.40026C47.7608 8.87899 48.2989 8.6207 49.0649 8.6207C49.7442 8.6207 50.2503 8.89777 50.5832 9.44722C50.916 9.99666 51.0802 10.8748 51.0802 12.0723C51.0802 14.4345 50.4236 15.6179 49.1105 15.6179M50.4008 5.52126C49.5254 5.52126 48.8187 5.7091 48.2715 6.0801C47.7289 6.45109 47.3003 6.88783 46.9812 7.38562H46.7988L46.2562 5.75137H43.1557V24.1508H46.9812V19.2058C46.9812 18.8301 46.9675 18.4826 46.9356 18.1585C46.9037 17.8298 46.8672 17.5198 46.8216 17.224H46.9812C47.2821 17.6138 47.6879 17.9707 48.194 18.2947C48.7001 18.6234 49.3977 18.7831 50.2868 18.7831C51.1759 18.7831 51.9966 18.5295 52.6988 18.027C53.401 17.5245 53.9572 16.7779 54.363 15.787C54.7688 14.8008 54.974 13.5751 54.974 12.1146C54.974 9.96849 54.5591 8.33424 53.7292 7.20717C52.8994 6.0801 51.7915 5.51656 50.4008 5.51656M0.0227975 18.553H9.81662V15.8011H0.0227975V18.553ZM35.5049 15.6132C34.6887 15.6132 34.1325 15.308 33.8315 14.7022C33.5306 14.0964 33.3802 13.2229 33.3802 12.0911V11.7436C33.3938 10.7011 33.5534 9.92152 33.8543 9.40026C34.1553 8.87899 34.6933 8.6207 35.4639 8.6207C36.1432 8.6207 36.6493 8.89777 36.9822 9.44722C37.315 9.99666 37.4792 10.8748 37.4792 12.0723C37.4792 14.4345 36.8226 15.6179 35.5094 15.6179M36.7998 5.52126C35.9244 5.52126 35.2131 5.7091 34.6705 6.0801C34.1279 6.45109 33.6993 6.88783 33.3802 7.38562H33.1978L32.6552 5.75137H29.5547V24.1508H33.3802V19.2058C33.3802 18.8301 33.3665 18.4826 33.3346 18.1585C33.3026 17.8298 33.2662 17.5198 33.2206 17.224H33.3802C33.6811 17.6138 34.0869 17.9707 34.593 18.2947C35.0991 18.6234 35.7967 18.7831 36.6858 18.7831C37.5749 18.7831 38.3956 18.5295 39.0978 18.027C39.7999 17.5245 40.3562 16.7779 40.762 15.787C41.1678 14.8008 41.373 13.5751 41.373 12.1146C41.373 9.96849 40.9581 8.33424 40.1282 7.20717C39.2984 6.0801 38.1904 5.51656 36.7998 5.51656M56.7932 18.553H60.6187V0.83453H56.7932V18.5577V18.553Z"/>
  </svg>
</a>

