<?php
/**
 * Team Member Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$class_name = 'team-member';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}

$name = get_field('name') ?: '';
$title = get_field('title') ?: '';
$image = get_field('image') ?: '';
$bio = get_field('bio') ?: '';

?>

<div class="<?= esc_attr( $class_name ) ?>">
    <button class="team-member-toggle slide-in-out-toggle fade-in-on-scroll" target="">
        <div class="image-wrapper">
            <?php if ( is_array($image) ) : ?>
                <img src="<?= $image['url'] ?>" alt="<?= $image['alt'] ?>">
            <?php endif; ?>
        </div>
        <div class="member-info">
            <h5><?= $name ?></h5>
            <p><?= $title ?></p>
            <span class="toggle-plus">&plus;</span>
        </div>
    </button>

    <div class="team-member-bio slide-in-out-container">
        <a href="#" class="close-container">
            <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M48 1.39L46.61 0L24 22.61L1.39 0L0 1.39L22.61 24L0 46.61L1.39 48L24 25.39L46.61 48L48 46.61L25.39 24L48 1.39Z" fill="black"/>
            </svg>
            <span class="visuallyhidden">Close</span>
        </a>
        <h4><?= $name ?></h4>
        <div class="bio-content"><?= $bio ?></div>
    </div>
</div>
