<?php
/**
 * Project Info Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$class_name = 'project-info';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}

?>

<div class="sticky-banner-button">
    <div class="banner-content">
        <span class="toggle-text slide-in-out-toggle" data-target=".project-info"">Project Information
            <span class="toggle-icon toggle-plus">
                <svg width="26" height="25" viewBox="0 0 26 25" fill="#00FFD1" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M12.8251 24.999C19.7283 24.999 25.3246 19.4028 25.3246 12.4995C25.3246 5.59622 19.7283 0 12.8251 0C5.92178 0 0.325562 5.59622 0.325562 12.4995C0.325562 19.4028 5.92178 24.999 12.8251 24.999ZM13.5943 11.7304H17.8249V13.2688H13.5943V17.4994H12.0559V13.2688H7.82525V11.7304H12.0559V7.49976H13.5943V11.7304Z" />
                </svg>
            </span>
        </span>
    </div>
</div>

<div class="<?= esc_attr( $class_name ) ?> slide-in-out-container">
    <a href="#" class="close-container">
        <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M48 1.39L46.61 0L24 22.61L1.39 0L0 1.39L22.61 24L0 46.61L1.39 48L24 25.39L46.61 48L48 46.61L25.39 24L48 1.39Z" fill="black"/>
        </svg>
        <span class="visuallyhidden">Close</span>
    </a>

    <InnerBlocks />
</div>