<?php
/**
 * Project Tile Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$class_name = 'project-tile fade-in-on-scroll';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}

$get_post = get_field('get_post') ?: get_the_ID();
$accent_color = get_field( 'accent_color', $get_post ) ?: '#03B394';
$thumbnail_size = get_field( 'thumbnail_size', $get_post ) ?: 'small';
?>

<a class="<?= esc_attr( $class_name ) ?> <?= $thumbnail_size ?>" <?php if (!is_admin()){ ?>href="<?= get_permalink() ?><?php } ?>">
    <div class="image-container">
        <img src="<?= get_the_post_thumbnail_url($get_post) ?>" alt="<?= get_the_post_thumbnail_caption($get_post) ?>">
        <?php if (has_excerpt($get_post)) { ?>
            <div class="gradient-overlay" style="background-image: linear-gradient(128deg, <?= $accent_color ?> 12.25%, transparent 54.47%);">
                <div class="excerpt"><?= get_the_excerpt($get_post) ?></div>
            </div>
        <?php } ?>
    </div>
    <div class="text-content">
        <h5><?= get_the_title($get_post) ?></h5>
    </div>
</a>
