<?php
/**
 * Carousel Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */

// Create class attribute allowing for custom "className" and "align" values.
$class_name = 'carousel-block';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}

$atts = array();
$atts['data-autoplay'] = get_field('auto_play') ?: false;
$atts['data-autoplayspeed'] = get_field('auto_play_speed') ?: 5000;

$attributes = '';
foreach ( $atts as $attr => $value ) {
    if ( ! empty( $value ) ) {
        $attributes .= ' ' . $attr . '="' . $value . '"';
    }
}

$allowed_blocks = [
    [ 'acf/carousel-slide' ]
]
?>
<div <?= $anchor ?>class="<?= esc_attr( $class_name ) ?>" style="<?= esc_attr( $style ) ?> <?php if (is_admin()){ echo 'border: 1px solid; padding: 1em;'; } ?>"<?= $attributes ?>>
    <?php if (is_admin()) { echo '<h3>Carousel</h3>'; } ?>
    <?php
        echo '<InnerBlocks allowedBlocks="' . esc_attr( wp_json_encode( $allowed_blocks ) ) . '" />';
    ?>
    <p class="pager"></p>
</div>