<?php
namespace adw;
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

require 'plugin-update-checker-5.1/plugin-update-checker.php';

class Theme
{
    public static function init()
    {
        $myUpdateChecker = PucFactory::buildUpdateChecker(
	        'http://theme.helloapplied.com/theme.json',
	        __FILE__,
	        'adw'
        );

        add_action( 'init', ['adw\Theme', 'register_acf_blocks']);
        add_action('wp_enqueue_scripts', function(){
            self::enqueueStyles();
            self::enqueueScripts();
            });
        add_filter( 'body_class', ['adw\Theme', 'custom_body_class'] );
    }
    /**
     * Add custom field body class(es) to the body classes.
     *
     * It accepts values from a per-page custom field, and only outputs when viewing a singular static Page.
     *
     * @param array $classes Existing body classes.
     * @return array Amended body classes.
     */
    public static function custom_body_class( array $classes ) {
        $new_class = is_page() ? get_post_meta( get_the_ID(), 'body_class', true ) : null;

        if ( $new_class ) {
            $classes[] = $new_class;
        }

        return $classes;
    }
    public static function register_acf_blocks() {
        register_block_type( __DIR__ . '/blocks/site-svg-logo');
        register_block_type( __DIR__ . '/blocks/article-card-link');
        register_block_type( __DIR__ . '/blocks/project-list');
        register_block_type( __DIR__ . '/blocks/project-info');
        register_block_type( __DIR__ . '/blocks/project-block-link');
        register_block_type( __DIR__ . '/blocks/project-tile');
        register_block_type( __DIR__ . '/blocks/team-member');
        register_block_type( __DIR__ . '/blocks/contact-form');
        register_block_type( __DIR__ . '/blocks/carousel');
        register_block_type( __DIR__ . '/blocks/carousel-slide');
    }

    public static function getVersion()
    {
        // Get the theme info so that we can use the version in script and link tags
        $theme = wp_get_theme();
        return $theme->get('Version');
    }

    public static function enqueueStyles() {
        if(!is_admin()) {
            wp_enqueue_style(
                'adw-styles',
                get_stylesheet_directory_uri().'/css/build/style.css',
                null,
                self::getVersion()
                );
        }
    }

    public static function enqueueScripts() {
        wp_enqueue_script(
            'slick-nav',
            get_stylesheet_directory_uri() . '/js/jquery.slicknav.min.js',
            ['jquery'],
            '1.0.10',
            false);
        wp_enqueue_script(
            'slick-slider',
            get_stylesheet_directory_uri() . '/js/slick.min.js',
            ['jquery'],
            '1.5.9',
            false);
        wp_enqueue_script(
            'main-script',
            get_stylesheet_directory_uri() . '/js/main.js',
            ['jquery'],
            self::getVersion(),
            true);
    }
}

Theme::init();
