<?php
/**
 * Article Card Link Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$class_name = 'article-card-link';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}

$url = get_field('url') ?: '#';
$title = get_field('title') ?: '';
$date = get_field('date') ?: '';
$image = get_field('image') ?: '';
$description = get_field('description') ?: '';
$link_label = get_field('link_label') ?: 'Read Article';

?>
<div class="grid-item">
    <a class="<?= esc_attr( $class_name ) ?>" href="<?= $url ?>" target="_blank" rel="external">
        <div class="article-card-content">
            <div class="row card-header">
                <h5><?= $title ?></h5>
                <h6><?= $date ?></h6>
            </div>
            <?php if ( is_array($image) ) : ?>
                <img src="<?= $image['url'] ?>" alt="<?= $image['alt'] ?>">
            <?php endif; ?>
            <p><?= $description ?></p>
            <span class="link-label arrow-link"><?= $link_label ?></span>
        </div>
    </a>
</div>