<?php
/**
 * Contact Form Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */
$class_name = 'contact-form';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}

?>

<div class="<?= esc_attr( $class_name ) ?>">
    <form id="contact-form">
        <div class="row">
            <div class="form-group">
                <label for="first-name">First Name</label>
                <input type="text" id="first-name" name="first-name">
            </div>
            <div class="form-group">
                <label for="last-name">Last Name</label>
                <input type="text" id="last-name" name="last-name">
            </div>
        </div>
        <div class="row">
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email">
            </div>
        </div>
        <div class="row">
            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="phone" id="phone" name="phone">
            </div>
        </div>
        <div class="row">
            <div class="form-group">
                <label for="message">Message</label>
                <textarea id="message" name="message"></textarea>
            </div>
        </div>
        <input type="submit" value="Submit">
    </form>
</div>